import { httpRequest } from "@mescius/wijmo";

export default class DataService {
  dataMap = new Map();

  init(ready) {
    httpRequest("data/popUS.json", {
      success: (xhr) => {
        JSON.parse(xhr.responseText).forEach((el) =>
          this.dataMap.set(el.state, el)
        );
        ready();
      },
    });
  }

  getData(code) {
    return this.dataMap.get(code);
  }
}
