// React
import React from "react";
export const GdashTile = ({ icon, header, children, onTileClick }) => {
    const handleClick = () => {
        if (onTileClick) {
            onTileClick();
        }
    };
    return (<div className="tile" onClick={handleClick}>
      <div className="tile-header">
        {icon && <React.Fragment>{icon}</React.Fragment>}
        <span>{header}</span>
      </div>
      <div className="tile-content">{children}</div>
    </div>);
};
