import React, { useRef } from 'react';
import useEvent from 'react-use-event-hook';
import { Globalize, isIE } from '@mescius/wijmo';
import * as wjcChart from '@mescius/wijmo.chart';
import * as wjcMap from '@mescius/wijmo.chart.map';
import * as wjMap from '@mescius/wijmo.react.chart.map';
import * as wjChart from '@mescius/wijmo.react.chart';
import { DataService } from '../services/DataService';
const sources = [
    { name: 'None', value: '' },
    { name: 'Median Age', value: 'medianAge', fmtLegend: 'n0', fmtTooltip: '"Age: "n1' },
    { name: 'Home Value', value: 'medianHomeValueMort', fmtLegend: 'c0,"k"', fmtTooltip: '"Home Value: "c1,"k"' },
    { name: 'Household Income', value: 'medianIncome', fmtLegend: 'c0,"k"', fmtTooltip: '"Income: "c1,"k"' },
    { name: 'Net Worth', value: 'netWorth', fmtLegend: 'c0,"k"', fmtTooltip: '"Net Worth: "c1,"k"' },
    { name: 'Population', value: 'popTotal', fmtLegend: 'n0,,"m"', fmtTooltip: '"Population: "n1,,"m"' },
];
export const GdashMap = ({ palette, onSelected }) => {
    const selectedNameRef = useRef(null);
    const mapRef = useRef(null);
    const selectedDataSourceIndexRef = useRef(0);
    const zoomTo = useEvent((layer) => layer.map.zoomTo(layer.getGeoBBox()));
    const tooltipContent = useEvent((o) => {
        const source = sources[selectedDataSourceIndexRef.current];
        const val = binding(o, source.value);
        if (val) {
            return `<b>${o.name}</b><br>${Globalize.formatNumber(val, source.fmtTooltip || '')}`;
        }
        else {
            return o.name;
        }
    });
    const binding = (o, name) => {
        const key = Number(o.fips.toString().slice(2));
        const item = DataService.getData(key);
        return item ? item[name] : 0;
    };
    const mapInitialized = useEvent((map) => {
        mapRef.current = map;
        map.hostElement.addEventListener('click', (e) => {
            if (e && e.srcElement.tagName !== 'BUTTON') {
                let ht = map.hitTest(e);
                if (ht && ht.item) {
                    selectedNameRef.current = ht.item.name;
                    const code = Number(ht.item.fips.toString().slice(2));
                    onSelected(DataService.getData(code), ht.item.name);
                    map.layers[0]._clearCache();
                    map.invalidate();
                }
            }
        });
        map.rendered.addHandler(function (s, a) {
            const layer = map.layers[0];
            const g = layer._g;
            if (g && selectedNameRef.current) {
                let list = [];
                for (let i = 0; i < g.childNodes.length; i++) {
                    const node = g.childNodes[i];
                    let id = node.getAttribute('wj-map:id');
                    let f = layer._getFeatureById(id);
                    if (f.properties.name === selectedNameRef.current) {
                        let sw = isIE() ? 3 * a.engine.scale : 3;
                        node.setAttribute('stroke', palette[0]);
                        node.setAttribute('stroke-width', sw.toString());
                        list.push(node);
                    }
                }
                list.forEach((el) => el.parentNode.appendChild(el));
            }
        });
    });
    const selectSource = (target) => {
        selectedDataSourceIndexRef.current = target.selectedIndex;
        if (target.value) {
            mapRef.current.layers[0].colorScale = new wjcMap.ColorScale({
                binding: (o) => binding(o.properties, target.value),
                colors: wjcChart.Palettes.SequentialSingle.Blues,
                format: sources[selectedDataSourceIndexRef.current].fmtLegend
            });
        }
        else {
            mapRef.current.layers[0].colorScale = null;
            //target.selectedIndex = 0;
        }
        mapRef.current.layers[0]._clearCache();
        mapRef.current.invalidate();
    };
    return (<div className="map">
      <wjMap.FlexMap initialized={mapInitialized} header='Select state on the map to see its data' tooltipContent={tooltipContent}>
        <wjMap.GeoMapLayer url="assets/US.json" itemsSourceChanged={zoomTo}/>
        <wjChart.FlexChartLegend position="Left"/>
      </wjMap.FlexMap>
      <div className="legend">
        <label htmlFor="legend">Map Legend:</label>
        <select id="legend" className="control legend-select" defaultValue="1" onChange={({ target }) => selectSource(target)}>
          {sources.map((entity) => (<option key={`option_${entity.name}`} value={entity.value}>
              {entity.name}
            </option>))}
        </select>
      </div>
    </div>);
};
