import React, { useEffect, useState } from 'react';
import useEvent from 'react-use-event-hook';
import { TabPanel, Tab } from '@mescius/wijmo.react.nav';
import { HomeValueTile } from './components/HomeValueTile';
import { HouseholdIncomeTile } from './components/HouseholdIncomeTile';
import { MedianAgeTile } from './components/MedianAgeTile';
import { NetWorthTile } from './components/NetWorthTile';
import { PopulationTile } from './components/PopulationTile';
import { GdashMap } from './components/GdashMap';
import { DataService } from './services/DataService';
const palette = ['#00b075', '#f8ce45', '#ecf0ee'];
export const App = () => {
    const [name, setName] = useState(null);
    const [data, setData] = useState(null);
    useEffect(() => {
        DataService.init(() => {
            const data = DataService.getData(0);
            setName('US');
            setData(data);
        });
    }, []);
    const renderTiles = () => {
        if (!name || !data) {
            return null;
        }
        const dataUS = DataService.getData(0);
        return (<div className="data-group">
        <div className="group">
          <div className="group-title">{name}</div>
        </div>

        <TabPanel>
          <Tab>
            <a href="#demographics">Demographics</a>
            <div>
              <div className="data-col">{<PopulationTile data={data} palette={palette}/>}</div>
              <div className="data-col">{<MedianAgeTile data={data} palette={palette}/>}</div>
            </div>
          </Tab>
          <Tab>
            <a href="#affluence">Affluence</a>
            <div>
              <div className="data-col">{<NetWorthTile data={data} palette={palette}/>}</div>
              <div className="data-col">{<HouseholdIncomeTile data={data} palette={palette}/>}</div>
            </div>
          </Tab>
          <Tab>
            <a href="#home">Home Value</a>
            <div>
              <div className="data-col">{<HomeValueTile name={name} data={data} dataUS={dataUS} palette={palette}/>}</div>
            </div>
          </Tab>
        </TabPanel>
      </div>);
    };
    const onSelected = useEvent((data, name) => {
        setName(name);
        setData(data);
    });
    return (<div className="container">
      <GdashMap palette={palette} onSelected={onSelected}/>
      <div className="data">
        <div className="row">{renderTiles()}</div>
      </div>
    </div>);
};
